//texture tex0 < string ResourceName = "borders.tga"; >;
//texture tex1 < string ResourceName = "borderDirections.tga"; >;
//texture tex2 < string ResourceName = "TerraIncog.tga"; >;
//texture tex3 < string ResourceName = "Diag.tga"; >;
//texture tex4 < string ResourceName = "ColorWater.tga"; >;

float4x4 WorldMatrix		: World; 
float4x4 ViewMatrix		: View; 
float4x4 ProjectionMatrix	: Projection; 


sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Nearest; //Linear; //Point;
	MagFilter = Nearest; //Linear; //Point;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler ProvinceBorderTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler TerraIncognitaFiltered  =
sampler_state
{
##	Texture = <tex2>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler ProvinceBorderDiagTexture  =
sampler_state
{
##	Texture = <tex3>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler ColorWaterTexture  =
sampler_state
{
##	Texture = <tex4>;
##	MinFilter = Nearest;
##	MagFilter = Nearest;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float2 vTexCoord  : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float2  vTexCoord0 : TEXCOORD0;
    float2  vTexCoord1 : TEXCOORD1;
};


/////////////////////////////////////////////////////////////////////////////////

VS_OUTPUT VertexShader_Border(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;

	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	Out.vTexCoord0  = v.vTexCoord;

	float2 TexCoord = v.vTexCoord;

	TexCoord.x *= 2048;
	TexCoord.y *= 1024;

	Out.vTexCoord1 = TexCoord;

	return Out;
}

float4 PixelShader_ProvinceBorder( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = float4( 0.1, 0.1, 0.1, 0 );
	float4 BaseColor = tex2D( BaseTexture, v.vTexCoord0 );

	float2 TexCoord = v.vTexCoord1;

	TexCoord.y += 0.01;	// KGPORT temp

//	TexCoord %= 1;				// 0 => 1 range.. only thing we need is the decimal part.
	TexCoord = fmod(TexCoord, 1.0);
	TexCoord.y = 1.0 + (-TexCoord.y);
	TexCoord.x /= 16;				// it's 32 pieces, make it for the first, and add to x to point it to the right in the pixelshader
	TexCoord.x *= 0.8;

	float2 TexCoord2 = TexCoord;
	TexCoord.x += BaseColor.b;
	TexCoord2.x += BaseColor.a;

	float4 Color = tex2D( ProvinceBorderTexture, TexCoord );
	Color.rgb *= Color.a;
	float4 DiagColor = tex2D( ProvinceBorderDiagTexture, TexCoord2 );
	DiagColor.rgb *= DiagColor.a;

//	Color.rgb += DiagColor.rgb;
	Color.rgb = max( DiagColor.rgb, Color.rgb );
	Color.a = max( Color.a, DiagColor.a );

	float4 TerraIncognita = tex2D( TerraIncognitaFiltered, v.vTexCoord0 );
	Color.rgb += ( TerraIncognita.g + (-0.25) )*1.33;
	Color.a += max( ( TerraIncognita.g + (-0.25) )*1.33, 0 );

	Color.rgb += tex2D( ColorWaterTexture, v.vTexCoord0 ).aaa;

	return Color;
}

// only difference right now is it uses .r instead of .b
float4 PixelShader_CountryBorder( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = float4( 0.1, 0.1, 0.1, 0 );
	float4 BaseColor = tex2D( BaseTexture, v.vTexCoord0 );

	float2 TexCoord = v.vTexCoord1;

	TexCoord = fmod(TexCoord, 1.0);
	TexCoord.x *= 0.9375;			// 60 pixels color. 4 not.
	TexCoord.x /= 16;				// it's 16 pieces, make it for the first, and add to x to point it to the right in the pixelshader


	// This weird number is (I think) due to 5-bits of color gives bad precision.
	// 0.97, 0.968 is to little..  somewhere    0.9675 < x < 0.968
	// 0.96, 0.965, 0.9675 is to much
	// 0.98  color on right instead...
	// 0.9678 extremly close but to much (pink is shown in yellow)
	// 0.9679 extremly close but to much (pink is shown in yellow)
	// 0.96   ( PINK is shown in yellow)

	TexCoord.x += ( BaseColor.r * 0.97 );	// 0.97 is ok when we use 60 out of 64 pixels..

	// add and scale here to get bigger or smaller borders depending on zoom?

	float4 Color = tex2D( ProvinceBorderTexture, TexCoord );

	return Color;
}

// only difference right now is it uses .g instead of .b
float4 PixelShader_River( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = float4( 0.1, 0.1, 0.1, 0 );
	float4 BaseColor = tex2D( BaseTexture, v.vTexCoord0 );

	float2 TexCoord = v.vTexCoord1;

	TexCoord = fmod(TexCoord, 1.0);
	TexCoord.x *= 0.9375;			// 60 pixels color. 4 not.
	//TexCoord.y = 1.0 +( -TexCoord.y );
	TexCoord.x /= 16;				// it's 16 pieces, make it for the first, and add to x to point it to the right in the pixelshader


	// This weird number is (I think) due to 5-bits of color gives bad precision.
	// 0.97, 0.968 is to little..  somewhere    0.9675 < x < 0.968
	// 0.96, 0.965, 0.9675 is to much
	// 0.98  color on right instead...
	// 0.9678 extremly close but to much (pink is shown in yellow)
	// 0.9679 extremly close but to much (pink is shown in yellow)
	// 0.96   ( PINK is shown in yellow)

	TexCoord.x += ( BaseColor.g * 0.99 ); //0.98 );	// 0.97 is ok when we use 60 out of 64 pixels..
						// 0.99 for rivers.. WHY THE FUCK??!!

	// add and scale here to get bigger or smaller borders depending on zoom?

	float4 Color = tex2D( ProvinceBorderTexture, TexCoord );

	return Color;
}

/////////////////////////////////////////////////////////////////////////////////


technique ProvinceBorderShader
{
	pass p0
	{
		BlendEnable = true;

		VertexProgram = compile arbvp1 VertexShader_Border();
		FragmentProgram = compile arbfp1 PixelShader_ProvinceBorder();
	}
}


technique CountryBorderShader
{
	pass p0
	{
		BlendEnable = true;

		VertexProgram = compile arbvp1 VertexShader_Border();
		FragmentProgram = compile arbfp1 PixelShader_CountryBorder();
	}
}

technique RiverShader
{
	pass p0
	{
		BlendEnable = true;

		VertexProgram = compile arbvp1 VertexShader_Border();
		FragmentProgram = compile arbfp1 PixelShader_River();
	}
}
